import { View, Text, ImageBackground, Image } from "react-native";
import React, { useEffect, useLayoutEffect, useState } from "react";
import BackButton from "../components/Buttons/BackButton";
import { SafeAreaView } from "react-native";
import { ScrollView } from "react-native";
import { db } from "../../config/firebase";
import { doc, getDoc } from "firebase/firestore";
import Loader from "../components/Loaders/Loader";
import PageLoader from "../components/Loaders/PageLoader";
import { useTranslation } from "react-i18next";

export default function HowItsWork({ navigation }) {
  const [data, setData] = useState();
  const [isLoading, setIsLoading] = useState(true);
  const { t, i18n } = useTranslation();

  useEffect(() => {
    getCGV();
  }, []);

  async function getCGV() {
  const docRef = doc(db, i18n?.language === "en" ? "CGV_EN" : "CGV", "CGV");
    const docSnap = await getDoc(docRef);

    if (docSnap.exists()) {
      setData(docSnap.data());
    }
    setIsLoading(false);
  }

  useLayoutEffect(() => {
    navigation.setOptions({
      headerLeft: () => <BackButton onPress={navigation.goBack} />,
      headerTitle: "",
    });
  });

  if (isLoading) {
    return <PageLoader />;
  }

  const Card = ({ title, content }) => (
    <View className="mb-10 p-4">
      <Text style={{ fontFamily: "Inter_700Bold" }} className="text-3xl">
        {title}
      </Text>
      <Text className="text-base leading-6 text-gray-700">{content}</Text>
    </View>
  );
  return (
    <SafeAreaView className="flex-1 bg-white">
      <ScrollView
        className=""
        contentContainerStyle={{ paddingBottom: "100%" }}
      >
        <ImageBackground
          className="py-5"
          resizeMode="cover"
          source={require("../../assets/img/gbbb.png")}
        >
          <View className="flex-row items-center justify-around">
            <Image
              resizeMode="contain"
              source={require("../../assets/img/info.png")}
              className="w-32 h-32 mr-2"
            />
            <View>
              <Text
                style={{ fontFamily: "Inter_500Medium" }}
                className="text-3xl text-white mr-3"
              >
                {t("howitsworks_screen.comment")}
              </Text>
              <Text
                style={{ fontFamily: "Inter_500Medium" }}
                className="text-3xl text-white mr-3"
              >
                {t("howitsworks_screen.camarche")}
              </Text>
            </View>
          </View>
        </ImageBackground>
        <Card title={""} content={data.howitswork} />
        <Card title={"CGV"} content={data.cgv} />
        <Card title={"Mentions"} content={data.mentions} />
      </ScrollView>
    </SafeAreaView>
  );
}
