import {
  View,
  Text,
  Image,
  StatusBar,
  StyleSheet,
  Platform,
  Alert,
  Keyboard,
} from "react-native";
import React, { useCallback, useLayoutEffect, useMemo, useRef } from "react";
import PrimaryButton from "../components/Buttons/PrimaryButton";
import { Pressable } from "react-native";
import { useEffect } from "react";
import BackButton from "../components/Buttons/BackButton";
import { useTranslation } from "react-i18next";
import { TouchableOpacity } from "react-native";
import { Ionicons } from "@expo/vector-icons";
import {
  BottomSheetBackdrop,
  BottomSheetFlatList,
  BottomSheetModal,
  BottomSheetModalProvider,
  BottomSheetScrollView,
  BottomSheetTextInput,
} from "@gorhom/bottom-sheet";
import frFlag from "../../assets/img/fr.png";
import enFlag from "../../assets/img/en.png";
import { Badge } from "react-native-elements";

export default function Landing({ navigation }) {
  const { t, i18n } = useTranslation();

  const bottomSheetModalRef = useRef(null);

  // variables
  const snapPoints = useMemo(() => ["40%", "70%"], []);

  // callbacks
  const openModal = useCallback(() => {
    Keyboard?.dismiss();
    bottomSheetModalRef.current?.present();
  }, []);

  const closeModal = useCallback(() => {
    bottomSheetModalRef.current?.dismiss();
  }, []);

  const renderBackdrop = useCallback(
    (props) => (
      <BottomSheetBackdrop
        {...props}
        disappearsOnIndex={-1}
        // appearsOnIndex={1}
      />
    ),
    []
  );

  useLayoutEffect(() => {
    navigation.setOptions({
      // headerLeft: () => <BackButton w onPress={navigation.goBack} />,
      headerTitle: "",
      headerTransparent: true,
      headerRight: () => (
        <View className="flex-row items-center">
          <TouchableOpacity
            onPress={openModal}
            className="flex-row items-center"
          >
            <Text
              style={{ fontFamily: "Inter_500Medium" }}
              className="text-xl text-white"
            >
              {i18n?.language == "en" ? "EN" : "FR"}
            </Text>
            <Image
              source={i18n?.language == "en" ? enFlag : frFlag}
              className="mx-1 w-6 h-4 z-20"
            />
            <Ionicons name={`chevron-down-outline`} size={15} color={"white"} />
          </TouchableOpacity>
        </View>
      ),
    });
  }, [navigation, i18n?.language]);

  useEffect(() => {
    navigation
      .getParent()
      ?.setOptions({ tabBarStyle: { display: "none" }, tabBarVisible: false });
    return () =>
      navigation
        .getParent()
        ?.setOptions({ tabBarStyle: undefined, tabBarVisible: undefined });
  }, [navigation]);

  useEffect(() => {
    Platform.OS === "ios"
      ? StatusBar.setBarStyle("light-content")
      : (StatusBar.setBarStyle("light-content"),
        StatusBar.setBackgroundColor("#00000"));
    return () => {
      Platform.OS === "ios"
        ? StatusBar.setBarStyle("dark-content")
        : (StatusBar.setBarStyle("light-content"),
          Platform.OS !== "ios" && StatusBar.setBackgroundColor("#00000"));
    };
  }, []);

  return (
    <View className="flex-1">
      <View className="flex-1 w-full">
        <Image
          className="w-full h-full"
          source={require("../../assets/img/plaque_imma_login.jpg")}
          resizeMode={"stretch"}
        />

        {/* Overlay sombre */}
        <View
          className=""
          style={{
            ...StyleSheet.absoluteFillObject,
            backgroundColor: "rgba(0, 0, 0, 0.5)",
            justifyContent: "center",
            alignItems: "center",
          }}
        >
          <View className="absolute bottom-7 px-5 w-full">
            <Text
              className="text-white text-3xl"
              style={{ fontFamily: "Inter_500Medium" }}
            >
              {t("screens.landing.title")}
            </Text>
            <Text
              className="text-white text-lg"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              {t("screens.landing.text")}
            </Text>
            <View>
              <View className="w-full pt-10 pb-20">
                <PrimaryButton
                  text={t("screens.landing.btn1")}
                  isLoading={false}
                  onPress={() => navigation.navigate("Register")}
                />
                <View className="mt-4">
                  <PrimaryButton
                    outline
                    text={t("screens.landing.btn2")}
                    isLoading={false}
                    onPress={() =>
                      navigation.navigate("Login", { doNotShowNav: true })
                    }
                  />
                </View>
              </View>
            </View>
          </View>
        </View>
      </View>
      <BottomSheetModalProvider>
        <BottomSheetModal
          ref={bottomSheetModalRef}
          backdropComponent={renderBackdrop}
          index={0}
          snapPoints={snapPoints}
        >
          <View className="p-2">
            <TouchableOpacity
              className="flex-row items-center pb-3"
              onPress={() => {
                i18n.changeLanguage("fr");
                closeModal();
              }}
            >
              <Image
                source={require("../../assets/img/fr.png")}
                className="mr-4 rounded-full w-10 h-10 z-20"
              />
              <Text
                style={{ fontFamily: "Inter_500Medium" }}
                className="text-lg mr-2"
              >
                {t("text.french")}
              </Text>
              {i18n?.language == "fr" && <Badge status="success" />}
            </TouchableOpacity>
            <TouchableOpacity
              className="flex-row items-center py-3 border-y border-gray-200"
              onPress={() => {
                i18n.changeLanguage("en");

                closeModal();
              }}
            >
              <Image
                source={require("../../assets/img/en.png")}
                className="mr-4 rounded-full w-10 h-10 z-20"
              />
              <Text
                style={{ fontFamily: "Inter_500Medium" }}
                className="text-lg mr-2"
              >
                {t("text.english")}
              </Text>
              {i18n?.language == "en" && <Badge status="success" />}
            </TouchableOpacity>
          </View>
        </BottomSheetModal>
      </BottomSheetModalProvider>
    </View>
  );
}
