import { View, Text, Image, Platform, StatusBar } from "react-native";
import React, { useCallback, useLayoutEffect } from "react";
import { createMaterialTopTabNavigator } from "@react-navigation/material-top-tabs";
import MyFinds from "./MyFinds";
import MySearchs from "./MySearchs";
import { COLORS } from "../../styles/colors";
import { useSafeAreaInsets } from "react-native-safe-area-context";
import Find from "../Find";
import { auth } from "../../../config/firebase";
import PrimaryButton from "../../components/Buttons/PrimaryButton";
import { useFocusEffect } from "@react-navigation/native";
import { useTranslation } from "react-i18next";

export default function MyDemands({ navigation }) {
  const { t } = useTranslation();

  const Tab = createMaterialTopTabNavigator();
  const insets = useSafeAreaInsets();

  useLayoutEffect(() => {
    navigation.setOptions({
      headerTitle: "Mes demandes",
      header: () => (
        <View
          style={{ paddingTop: insets.top, backgroundColor: COLORS.primary }}
        ></View>
      ),
    });
  });

  useFocusEffect(
    useCallback(() => {
      Platform.OS === "ios"
        ? StatusBar.setBarStyle("light-content")
        : (StatusBar.setBarStyle("light-content"),
          StatusBar.setBackgroundColor("#00000"));
      return () => {
        Platform.OS === "ios"
          ? StatusBar.setBarStyle("dark-content")
          : (StatusBar.setBarStyle("light-content"),
            Platform.OS !== "ios" && StatusBar.setBackgroundColor("#00000"));
      };
    }, [])
  );

  if (!auth.currentUser) {
    return (
      <View
        style={{ marginTop: "-50%" }}
        className="flex-1 items-center justify-center bg-white"
      >
        <Image
          autoPlay
          className="w-24 h-24"
          source={require("../../../assets/img/user.png")}
        />
        <View className="w-10/12 self-center">
          <Text
            className="mt-10 text-lg text-black text-center"
            style={{ fontFamily: "Inter_500Medium" }}
          >
            Veuillez-vous identifier
          </Text>
          <Text className="mt-3 mb-5 text-sm text-gray-700 text-center">
            Le faire vous permettra de profiter de notre grande base de données
            de recherche
          </Text>
          <View className="mt-5 w-full bg-white">
            <PrimaryButton
              text={"Connexion"}
              onPress={() => navigation.navigate("Landing")}
            />
          </View>
        </View>
      </View>
    );
  }

  return (
    <Tab.Navigator
      screenOptions={{
        tabBarLabelStyle: {
          fontFamily: "Inter_500Medium",
          textTransform: "none",
          color: "white",
          fontSize: 17,
        },
        tabBarStyle: { backgroundColor: COLORS.primary },
        tabBarIndicatorStyle: { backgroundColor: "orange" },
      }}
    >
      <Tab.Screen
        name="MySearchs"
        component={MySearchs}
        options={{
          title: t("text.MySearchs"),
        }}
      />
      <Tab.Screen
        name="MyFinds"
        component={MyFinds}
        options={{
          title: t("text.MyFinds"),
        }}
      />
    </Tab.Navigator>
  );
}
