import {
  View,
  Text,
  ImageBackground,
  StyleSheet,
  TextInput,
  TouchableOpacity,
  Alert,
} from "react-native";
import React, { useLayoutEffect, useState } from "react";
import {
  updateProfile,
} from "firebase/auth";
import * as Haptics from "expo-haptics";
import { auth, db, storage } from "../../../config/firebase";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import { Keyboard } from "react-native";
import { doc, setDoc } from "firebase/firestore";
import BackButton from "../../components/Buttons/BackButton";
import { SafeAreaView } from "react-native";
import { INPUT_CLASS } from "../../styles/constants";



export default function MyRIB({ navigation, route }) {
  const [rib, setRib] = useState("");
  const [bic, setBic] = useState("");
  const [isLoading, setIsLoading] = useState(false);

  const userInfo = route.params.userInfo;

  useLayoutEffect(() => {
    navigation.setOptions({
      headerLeft: () => <BackButton onPress={navigation.goBack} />,
      headerTitle: "Infos bancaires",
      headerRight: () => (
        <TouchableOpacity
          onPress={update}
          disabled={isLoading ? true : false}
          style={{
            opacity: isLoading ? 0.6 : 1,
          }}
        >
          <Text
            style={{ fontFamily:"Inter_700Bold" }}
            className="text-center text-blue-500 text-sm"
          >
            Enregistrer
          </Text>
        </TouchableOpacity>
      ),
    });
  });
 

  const update = async () => {

    const myRef = doc(db, "users", auth.currentUser.uid);
    await setDoc(
      myRef,
      {
        rib: rib,
        bic: bic,
      },
      { merge: true }
    );

    
    navigation.popToTop();
  };
  return (
    <SafeAreaView className="flex-1 bg-white">
      <KeyboardAwareScrollView
        keyboardDismissMode="interactive"
        keyboardShouldPersistTaps="handled"
        resetScrollToCoords={{ x: 0, y: 0 }}
        scrollEnabled
        contentContainerStyle={{ paddingBottom: "100%" }}
      >
        <View className="flex-1 flex-col justify-between">
          <View className="flex-1 px-5 py-5">
            <View>
              <Text
                className="text-sm text-black mb-3"
                style={{ fontFamily:"Inter_700Bold" }}
              >
                Votre RIB
              </Text>
              <TextInput
                className={INPUT_CLASS}
                placeholder={userInfo.rib}
                placeholderTextColor={"gray"}
                value={rib}
                onChangeText={(val) => {
                  setRib(val);
                }}
              />
            </View>

            <View className="mt-8">
              <Text
                className="text-sm text-black mb-3"
                style={{ fontFamily:"Inter_700Bold" }}
              >
                Code BIC/SWIFT
              </Text>
              <TextInput
                className={INPUT_CLASS}
                placeholder={userInfo.bic}
                placeholderTextColor={"gray"}
                value={bic}
                onChangeText={(val) => {
                  setBic(val);
                }}
              />
            </View>

          </View>
        </View>
      </KeyboardAwareScrollView>
    </SafeAreaView>
  );
}
