import {
  View,
  Text,
  Dimensions,
  Linking,
  ActivityIndicator,
} from "react-native";
import React, {
  useCallback,
  useEffect,
  useMemo,
  useRef,
  useState,
} from "react";
import { auth, db } from "../../../config/firebase";
import {
  addDoc,
  collection,
  doc,
  getDoc,
  getDocs,
  onSnapshot,
  query,
  updateDoc,
  where,
} from "firebase/firestore";
import { Pressable } from "react-native";
import { SafeAreaView } from "react-native";
import { FlatList } from "react-native";
import moment from "moment";
import { COLORS } from "../../styles/colors";
import { TouchableOpacity } from "react-native";
import { Ionicons } from "@expo/vector-icons";
import BottomSheet, {
  BottomSheetBackdrop,
  BottomSheetModal,
  BottomSheetModalProvider,
  BottomSheetScrollView,
  BottomSheetView,
} from "@gorhom/bottom-sheet";
import * as Haptics from "expo-haptics";
import { Alert } from "react-native";
import { useFocusEffect } from "@react-navigation/native";
import Loader from "../../components/Loaders/Loader";
import stripe from "@stripe/stripe-react-native";
import axios from "axios";
import qs from "qs";
import { WebView } from "react-native-webview";
import { decode, encode } from "base-64";
import { Image } from "react-native";
import ImageViewer from "react-native-image-zoom-viewer";
import Modal from "react-native-modal";
import {
  BUTTON_CLASS,
  BUTTON_OUTLINE_CLASS,
  DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
} from "../../styles/constants";
import { XMarkIcon } from "react-native-heroicons/solid";
import * as Clipboard from "expo-clipboard";
import {
  SENDGRID_API_KEY,
  SENDGRID_FROM,
  PAYPAL_LIVE_CLIENT,
  PAYPAL_LIVE_SECRET,
} from "@env";
import BackButton from "../../components/Buttons/BackButton";
import { Platform } from "react-native";
import * as WebBrowser from "expo-web-browser";
import Purchases, { makePurchase } from "react-native-purchases";
import PageLoader from "../../components/Loaders/PageLoader";
import SmallPrimaryButton from "../../components/Buttons/SmallPrimaryButton";
import PrimaryButton from "../../components/Buttons/PrimaryButton";
import sendAdminNotif from "../../utils/sendAdminNotif";
import { useTranslation } from "react-i18next";

if (!global.btoa) {
  global.btoa = encode;
}

if (!global.atob) {
  global.atob = decode;
}

export default function MySearchs({ navigation }) {
  const [data, setData] = useState([]);
  const [offers, setOffers] = useState([]);
  const [isPhotoModalOpen, setIsPhotoModalOpen] = useState(false);
  const [isInfoModalIsOpen, setIsInfoModalIsOpen] = useState(false);
  const [modalData, setModalData] = useState(null);
  const [imageForViewer, setImageForViewer] = useState(null);

  const [paypalUrl, setPaypalUrl] = useState(null);
  const [accessToken, setAccessToken] = useState("");

  const [paymentIsLoading, setPaymentIsLoading] = useState(false);
  const [isLoading, setIsLoading] = useState(true);

  const { t } = useTranslation();

  useEffect(() => {
    getSearchs();
  }, []);

  useFocusEffect(
    useCallback(() => {
      getSearchs();
    }, [])
  );

  const buyOffer = async () => {
    setPaymentIsLoading(true);
    const ID =
      modalData?.type == "voitures de collection"
        ? "com_collection"
        : modalData?.type == "bateaux"
        ? "com_bateaux"
        : modalData?.type == "camionnettes"
        ? "com_camionnettes"
        : modalData?.type == "camions"
        ? "com_camions"
        : modalData?.type == "camping-cars"
        ? "com_campingcars"
        : modalData?.type == "caravane"
        ? "com_caravane"
        : modalData?.type == "motos"
        ? "com_motos"
        : modalData?.type == "quads"
        ? "com_quads"
        : modalData?.type == "remorques"
        ? "com_remorques"
        : modalData?.type == "voitures"
        ? "com_voitures"
        : modalData?.type == "véhicules de chantier"
        ? "com_chantier"
        : modalData?.type == "voitures de luxe"
        ? "com_luxe"
        : modalData?.type == "véhicules 3 roues"
        ? "com_3roues"
        : modalData?.type == "véhicules agricoles"
        ? "com_agricoles"
        : modalData?.type == "véhicules utilitaires"
        ? "com_utilitaires"
        : modalData?.type == "vélos"
        ? "com_velos"
        : modalData?.type == "autres types"
        ? "com_others"
        : "com_voitures";
    await Purchases.purchaseProduct(ID)

      // try {
      //   const offerings = await Purchases.getOfferings();
      //   if (offerings.current) {
      //     const products = offerings.current.availablePackages;
      //     console.log(products);
      //   }
      // } catch (error) {
      //   console.error("Error fetching products:", error);
      // } finally {
      //   setPaymentIsLoading(false);
      // }

      .then(() => {
        setPaymentIsLoading(false);
        updateToIsPaied("AppStore");
        closeModal();
      })
      .catch((err) => {
        setPaymentIsLoading(false);
        Alert.alert(
          "Le paiement a échoué",
          `${err}`
          // "Nous vous prions de rééssayer ultérieurement"
        );
      });
    // const { purchaserInfo } = await makePurchase("com_camions");
    // const { purchaserInfo } = await makePurchase(ID);
    // if (purchaserInfo.entitlements.active.yourEntitlementIdentifier.isActive) {
    //   console.log(`Achat réussi pour le produit ${ID}`);
    // } else {
    //   console.log(`Achat échoué pour le produit ${ID}`);
    // }
  };

  // const getOfferings = async () => {
  //   const offerings = await Purchases.getOfferings();
  //   if (
  //     offerings.current !== null &&
  //     offerings.current.availablePackages.length !== 0
  //   ) {
  //     console.log("offerings");
  //     console.log(offerings.current.lifetime.product);
  //     setOffers(offerings);
  //   }
  // };

  const handlePaypal = async () => {
    closeModal();
    const dataDetail = {
      intent: "sale",
      payer: {
        payment_method: "paypal",
      },
      transactions: [
        {
          amount: {
            currency: "EUR",
            total: `${modalData.price}`,
            details: {
              shipping: "0",
              subtotal: "0",
              shipping_discount: "0",
              insurance: "0",
              handling_fee: "0",
              tax: "0",
            },
          },
          description: "InApp details véhicule paiement",
          payment_options: {
            allowed_payment_method: "IMMEDIATE_PAY",
          },
          item_list: {
            items: [
              {
                name: `Véhicule ${modalData.licensePlate}`,
                description: "",
                quantity: "1",
                price: "0",
                tax: "0",
                sku: `${modalData.licensePlate}-sku`,
                currency: "EUR",
              },
            ],
          },
        },
      ],
      redirect_urls: {
        return_url: "https://sur4plots.com/success_payments",
        cancel_url: "https://sur4plots.com/return",
      },
    };

    const url = `https://api-m.paypal.com/v1/oauth2/token`;
    // const url = `https://api-m.sandbox.paypal.com/v1/oauth2/token`;

    const data = {
      grant_type: "client_credentials",
    };

    const auth = {
      username: `${PAYPAL_LIVE_CLIENT}`,
      password: `${PAYPAL_LIVE_SECRET}`,
    };

    const options = {
      method: "post",
      headers: {
        "content-type": "application/x-www-form-urlencoded",
        "Access-Control-Allow-Credentials": true,
      },
      data: qs.stringify(data),
      auth: auth,
      url,
    };
    axios(options)
      .then((response) => {
        setAccessToken(response.data.access_token);
        axios
          .post(`https://api-m.paypal.com/v1/payments/payment`, dataDetail, {
            headers: {
              "Content-Type": "application/json",
              Authorization: `Bearer ${response.data.access_token}`,
            },
          })
          .then((response) => {
            const { id, links } = response.data;
            const approvalUrl = links.find(
              (data) => data.rel == "approval_url"
            ).href;

            setPaypalUrl(approvalUrl);
          })
          .catch((err) => {
            // console.log({ ...err });
            Alert.alert("Erreur", "Une erreur est survenue");
          });
      })
      .catch((err) => {
        console.log(err);
      });
  };

  const handleNavigationStateChange = (navState) => {
    // console.log(navState.url);
    if (navState.url.includes("sur4plots.com/success_payments")) {
      setPaypalUrl(null);
      updateToIsPaied("PayPal");
    } else if (navState.url.includes("sur4plots.com/return")) {
      setPaypalUrl(null);
    }
  };

  async function getSearchs() {
    const q = query(
      collection(db, "searchs"),
      where("userId", "==", auth.currentUser.uid)
    );

    const querySnapshot = await getDocs(q);
    const dataArr = [];
    querySnapshot.forEach(async (res) => {
      const otherData = await getMoreInfo(res.data().type);
      dataArr.push({
        id: res.id,
        ...res.data(),
        price: otherData[0].price,
        image: otherData[0].image,
      });
      setData(dataArr);
    });

    setTimeout(() => {
      setIsLoading(false);
    }, 500);
  }

  async function getMoreInfo(type) {
    const q = query(collection(db, "categories"), where("name", "==", type));
    const querySnapshot = await getDocs(q);
    const dataArr = [];
    querySnapshot.forEach(async (res) => {
      dataArr.push({ id: res.id, ...res.data() });
    });
    return dataArr;
  }

  const bottomSheetModalRef = useRef(null);

  // variables
  const snapPoints = useMemo(() => ["90%"], []);

  // callbacks
  const openModal = useCallback((item) => {
    setModalData(item);
    const imageUrls = item?.photos?.map((image) => ({ url: image }));
    setImageForViewer(imageUrls);
    bottomSheetModalRef.current?.present();
  }, []);

  const closeModal = useCallback(() => {
    bottomSheetModalRef.current?.dismiss();
  }, []);

  const renderBackdrop = useCallback(
    (props) => (
      <BottomSheetBackdrop
        {...props}
        disappearsOnIndex={-1}
        // appearsOnIndex={1}
      />
    ),
    []
  );

  const openMapsWithCoordinates = async (item) => {
    const url = `http://maps.google.com?q=${item.address.coords.lat},${item.address.coords.long}`;

    await Linking.openURL(url);
  };

  async function seeDetails() {
    if (modalData?.paymentStatus == "paid") {
      Alert.alert(
        `${
          modalData?.address.street +
          " · " +
          modalData?.address.city +
          " " +
          modalData?.address.postalCode +
          ", " +
          modalData?.address.country
        }`,
        "est la dernière localisation du véhicule",
        [
          {
            text: "Ouvrir dans Maps",
            onPress: () => openMapsWithCoordinates(modalData),
          },
          {
            text: "Copier dans le presse-papier",
            onPress: async () =>
              await Clipboard.setStringAsync(modalData?.address),
          },
          {
            text: "Retour",
            style: "cancel",
          },
        ],
        {
          cancelable: false,
        }
      );
      return;
    }

    if (Platform.OS === "ios") {
      buyOffer();
    } else {
      sendAdminNotif(
        `Un utilisateur veut payer pour voir l'adresse de son véhicule`
      );
      Alert.alert(
        "Vous allez être redirigé(e) vers la passerelle de paiement",
        "Après avoir payé, vous verrez la dernière localisation du véhicule",
        [
          {
            text: "Carte Bancaire",
            onPress: () => {
              closeModal();
              setTimeout(() => {
                navigation.navigate("Pay", {
                  searchId: modalData.id,
                  searchFinderId: modalData.finderId,
                  amount: modalData.price,
                });
              }, 500);
            },
          },
          {
            text: "PayPal",
            onPress: () => {
              closeModal();

              setTimeout(() => {
                handlePaypal();
              }, 500);
            },
          },
          {
            text: "Annuler",
            style: "cancel",
          },
        ],
        {
          cancelable: true,
        }
      );
    }
  }

  const updateToIsPaied = async (method) => {
    sendAdminNotif(`Nouveau paiement ✅`);
    sendAdminNotif(
      `Un utilisateur a payé par ${method.toUpperCase()} pour voir les infos de son véhicule ✅`
    );
    const docRef = doc(db, "searchs", modalData.id);
    await updateDoc(docRef, {
      paymentStatus: "paid",
      paymentMethod: method,
      price: String(modalData.price),
      paiedAt: moment().format(),
    });
    getSearchs();
    const getFinderInfos = await getDoc(doc(db, "users", modalData.finderId));

    const getSearcherInfos = await getDoc(doc(db, "users", modalData.userId));

    // ALL NOTIFS FOR FINDER
    sendPushNotifToFinder(getFinderInfos.data().expoPushToken);
    sendMailToFinder(getFinderInfos.data());
    sendNotifToFinder(modalData.finderId);

    // ALL NOTIFS FOR SEARCHER
    sendPushNotifToSearcher(getSearcherInfos.data().expoPushToken);
    sendNotifToSearcher(modalData.userId);
  };

  function enleverEspaces(chaine) {
    return chaine.replace(/\s/g, "");
  }

  const sendMailToFinder = async (finderInfo) => {
    await axios.post(
      "https://api.sendgrid.com/v3/mail/send",
      {
        personalizations: [
          {
            to: [
              {
                email: `${finderInfo.email}`,
              },
            ],
            dynamic_template_data: {
              first_name:
                finderInfo.firstName !== ""
                  ? finderInfo.firstName + " " + finderInfo.lastName
                  : "cher utilisateur",
            },
          },
        ],
        from: {
          email: `${SENDGRID_FROM}`,
        },
        template_id: enleverEspaces("d-930e11a826e145cba20f78914ae18841"),
      },
      {
        headers: {
          authorization: `Bearer ${SENDGRID_API_KEY}`,
          "Content-Type": "application/json",
        },
      }
    );
  };

  async function sendPushNotifToFinder(expoPushToken) {
    const message = {
      to: expoPushToken,
      sound: "default",
      title: "Vous avez un match ! ✅",
      body: "Votre signalement au sein de l'application Sur4plots a permis à un citoyen de retrouver son véhicule !",
    };

    await fetch("https://exp.host/--/api/v2/push/send", {
      method: "POST",
      headers: {
        Accept: "application/json",
        "Accept-encoding": "gzip, deflate",
        "Content-Type": "application/json",
      },
      body: JSON.stringify(message),
    });
  }

  async function sendNotifToFinder(finderId) {
    const dataToAdd = {
      title: "Vous avez un match ! ✅",
      title_en: "You have a match! ✅",
      text: "Votre signalement au sein de l'application Sur4plots a permis de retrouver votre véhicule",
      text_en: "Your report within the Sur4plots application has allowed us to find your vehicle",
      userId: finderId,
      isViewed: false,
      createdAt: moment().format(),
    };

    await addDoc(collection(db, "notifications"), dataToAdd);
  }

  async function sendPushNotifToSearcher(expoPushToken) {
    const message = {
      to: expoPushToken,
      sound: "default",
      title: "Paiement validé !",
      body: "Vous pouvez dès à présent consulter l'adresse de votre véhicule",
    };

    await fetch("https://exp.host/--/api/v2/push/send", {
      method: "POST",
      headers: {
        Accept: "application/json",
        "Accept-encoding": "gzip, deflate",
        "Content-Type": "application/json",
      },
      body: JSON.stringify(message),
    });
  }

  async function sendNotifToSearcher(searcherId) {
    const dataToAdd = {
      title: "Paiement validé !",
      title_en: "Payment validated !",
      text: "Vous pouvez dès à présent consulter l'adresse de votre véhicule",
      text_en: "You can now check the address of your vehicle",
      userId: searcherId,
      isViewed: false,
      createdAt: moment().format(),
    };

    await addDoc(collection(db, "notifications"), dataToAdd);
  }

  const Card = ({ item }) => (
    <Pressable
      className="p-3 bg-gray-50 border border-gray-200 mb-5 rounded-md flex-row items-center justify-between"
      onPress={() => openModal(item)}
    >
      <View className="flex-1 flex-row items-center">
        <View>
          <View className="flex-row items-center">
            <Text
              className="text-base"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              {t('vehicle_screen.licensePlateTitle')}: {item?.plate?.toUpperCase()}
            </Text>
          </View>
          <View className="my-1 flex-row items-center">
            <Text
              className="text-base capitalize"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              {t('vehicle_screen.insuranceTitle')}: {item?.assurance?.toUpperCase()}
            </Text>
          </View>
          {item?.paymentStatus == "paid" && (
            <Text
              className="text-base"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              {t('vehicle_screen.viewPositionButton', { price: item.price })}{" "}
              <Text
                className="text-base"
                style={{ fontFamily: "Inter_400Regular", color: "#2ecc71" }}
              >
                {`${
                  item?.paymentStatus !== "paid"
                    ? t('vehicle_screen.viewPositionButton', { price: item.price })
                    : `${
                        item?.address.street +
                        " · " +
                        item?.address.city +
                        " " +
                        item?.address.postalCode +
                        ", " +
                        item?.address.country
                      }`
                }`}
              </Text>
            </Text>
          )}
          <View className="mt-1 flex-row items-center">
            {item.status == "progress" ? (
              <Ionicons name="checkmark-outline" size={15} color="orange" />
            ) : (
              <Ionicons name="checkmark-outline" size={15} color="#27ae60" />
            )}
            <Text
              className="text-base ml-1"
              style={{ fontFamily: "Inter_300Light" }}
            >
              {item.status == "progress"
                ? t('vehicle_screen.inProgress')
                : `${t('vehicle_screen.found')}${
                    item.paymentStatus == "paid" ? t('vehicle_screen.paid') : t('vehicle_screen.unpaid')
                  }`}
            </Text>
          </View>
        </View>
      </View>
      <View className="w-2/12">
        <SmallPrimaryButton onPress={() => openModal(item)} text={""} />
      </View>
    </Pressable>
  );
  

  const CardList = ({ title, value }) => (
    <View className="py-2">
      <Text
        className="text-gray-500 text-base"
        style={{ fontFamily: "Inter_300Light" }}
      >
        {title}
      </Text>
      <Text
        className="uppercase text-lg"
        style={{ fontFamily: "Inter_400Regular" }}
      >
        {value}
      </Text>
    </View>
  );

  if (isLoading) {
    return <PageLoader />;
  }

  if (!data.length) {
    return (
      <View className="flex-1 bg-white items-center justify-center px-[10%] -mt-[50%]">
  <Image
    source={require("../../../assets/img/x.png")}
    resizeMode="contain"
    className="w-24 h-24"
  />
  <Text
    className="text-base text-center text-black mt-10 mb-2"
    style={{ fontFamily: "Inter_500Medium" }}
  >
    {t('vehicle_screen.noRequestTitle')}
  </Text>
  <Text className="text-sm text-center text-gray-700">
    {t('vehicle_screen.noRequestDescription')}
  </Text>
</View>
    );
  }

  return (
    <SafeAreaView className="flex-1 bg-white">
    <FlatList
      className="p-4"
      contentContainerStyle={{
        paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
      }}
      keyExtractor={(item) => item.id}
      data={data}
      renderItem={({ item }) => <Card item={item} />}
    />
    <BottomSheetModalProvider>
      <View className="flex-1">
        <BottomSheetModal
          ref={bottomSheetModalRef}
          backdropComponent={renderBackdrop}
          index={0}
          snapPoints={snapPoints}
        >
          <BottomSheetScrollView
            className=""
            contentContainerStyle={{
              paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
            }}
          >
            <View className="pb-4 px-4">
              <Text
                className="text-xl py-2"
                style={{ fontFamily: "Inter_500Medium" }}
              >
                {t('vehicle_screen.infoHeader')}
              </Text>
              <Pressable
                onPress={() => setIsInfoModalIsOpen(!isInfoModalIsOpen)}
                className="pt-2 pb-4"
              >
                <View className="flex-row items-center justify-between">
                  <View className="flex-row">
                    <Text
                      className="text-base text-blue-500"
                      style={{
                        fontFamily: "Inter_300Light",
                        color: COLORS.primary,
                      }}
                    >
                      {t('vehicle_screen.importantInfoText')}
                    </Text>
                  </View>
                  {isInfoModalIsOpen ? (
                    <Ionicons
                      name="chevron-up-outline"
                      size={15}
                      color={COLORS.primary}
                    />
                  ) : (
                    <Ionicons
                      name="chevron-down-outline"
                      size={15}
                      color={COLORS.primary}
                    />
                  )}
                </View>
  
                {isInfoModalIsOpen && (
                  <Text
                    style={{
                      fontFamily: "Inter_400Regular",
                    }}
                    className="py-2 text-base leading-6 text-gray-600"
                  >
                    {t('vehicle_screen.importantInfoDescription')}
                  </Text>
                )}
              </Pressable>
              <CardList
                title={t('vehicle_screen.licensePlateTitle')}
                value={modalData?.plate}
              />
              <CardList title={t('vehicle_screen.insuranceTitle')} value={modalData?.assurance} />
              <CardList title={t('vehicle_screen.vehicleTypeTitle')} value={modalData?.type} />
              <CardList
                title={t('vehicle_screen.publishedOnTitle')}
                value={moment(modalData?.createdAt).format(
                  "DD/MM/YYYY à hh:mm a"
                )}
              />
              {modalData?.status == "ended" && (
                <CardList
                  title={t('vehicle_screen.foundOnTitle')}
                  value={moment(modalData?.findedAt).format(
                    "DD/MM/YYYY à hh:mm a"
                  )}
                />
              )}
              <CardList
                title={t('vehicle_screen.statusTitle')}
                value={
                  modalData?.status == "ended" ? "Terminé" : "En recherche"
                }
              />
  
              {modalData?.status == "ended" && (
                <>
                  <View className="mt-4">
                    <PrimaryButton
                      text={t('vehicle_screen.viewPhotoButton')}
                      isLoading={false}
                      onPress={() => {
                        setIsPhotoModalOpen(true);
                      }}
                    />
                  </View>
                  <View className="mt-2">
                    <PrimaryButton
                      green
                      text={
                        modalData?.paymentStatus !== "paid"
                          ? t('vehicle_screen.viewPositionButton', { price: modalData.price })
                          : t('vehicle_screen.address', {
                              street: modalData?.address.street,
                              city: modalData?.address.city,
                              postalCode: modalData?.address.postalCode,
                              country: modalData?.address.country
                            })
                      }
                      isLoading={false}
                      onPress={seeDetails}
                    />
                  </View>
                </>
              )}
            </View>
          </BottomSheetScrollView>
        </BottomSheetModal>
      </View>
    </BottomSheetModalProvider>
    <Modal
      style={{
        flex: 1,
        position: "absolute",
        width: "100%",
        height: "100%",
        padding: 0,
        margin: 0,
      }}
      visible={paypalUrl != null ? true : false}
      transparent={true}
    >
      <View
        style={{ backgroundColor: COLORS.primary }}
        className={
          Platform.OS == "ios"
            ? "flex-row items-center px-2 pt-10 pb-2"
            : "flex-row items-center p-3"
        }
      >
        <BackButton white onPress={() => setPaypalUrl(null)} />
        <TouchableOpacity onPress={() => setPaypalUrl(null)}>
          <Text
            style={{ fontFamily: "Inter_500Medium" }}
            className="text-white ml-2 text-sm"
          >
            {t('vehicle_screen.cancelAndReturn')}
          </Text>
        </TouchableOpacity>
      </View>
      <WebView
        style={{
          flex: 1,
          height: "100%",
          width: "100%",
        }}
        source={{ uri: paypalUrl }}
        onNavigationStateChange={handleNavigationStateChange}
        javaScriptEnabled
        domStorageEnabled
        startInLoadingState={false}
      />
    </Modal>
    <Modal
      style={{
        flex: 1,
        position: "absolute",
        width: "100%",
        height: "100%",
        padding: 0,
        margin: 0,
      }}
      visible={isPhotoModalOpen}
      transparent={true}
    >
      <ImageViewer
        renderHeader={() => (
          <>
            <View
              style={{
                top: 50,
                zIndex: 200,
              }}
              className="absolute w-full"
            >
              <TouchableOpacity
                className="p-5"
                style={{ alignSelf: "flex-end", marginRight: 10 }}
                onPress={() => {
                  setIsPhotoModalOpen(false);
                }}
              >
                <XMarkIcon size={30} color={"white"} />
              </TouchableOpacity>
            </View>
            <View
              style={{
                bottom: 50,
                zIndex: 200,
              }}
              className="absolute w-full"
            >
              <Text
                style={{ fontFamily: "Inter_700Bold" }}
                className="text-white text-xl text-center"
              >
                {modalData.plate}
              </Text>
            </View>
          </>
        )}
        enableSwipeDown
        onCancel={() => setIsPhotoModalOpen(false)}
        onSwipeDown={() => setIsPhotoModalOpen(false)}
        enableImageZoom
        imageUrls={imageForViewer}
      />
    </Modal>
    {paymentIsLoading && (
      <View
        style={{ backgroundColor: "rgba(0,0,0,0.5)" }}
        className="flex-1 absolute h-full w-full items-center justify-center"
      >
        <ActivityIndicator size={"large"} color={"white"} />
      </View>
    )}
    {JSON.stringify(offers.products)}
  </SafeAreaView>
  
  );
}
