import { doc, getDoc } from "firebase/firestore";
import { db } from "../../config/firebase";

export default async function sendAdminNotif(message) {
  const docSnap = await getDoc(
    doc(db, "users", "a0HIrmhFaZdd4DxLExiNpIt4xq43")
  );
  if (!docSnap.exists()) {
    return;
  }

  // send push notif
  const MESSAGE = {
    to: docSnap.data().expoPushToken,
    sound: "default",
    title: `Admin S4Plots`,
    body: `${message}`,
  };

  await fetch("https://exp.host/--/api/v2/push/send", {
    method: "POST",
    headers: {
      Accept: "application/json",
      "Accept-encoding": "gzip, deflate",
      "Content-Type": "application/json",
    },
    body: JSON.stringify(MESSAGE),
  });
}
